<?php
declare(strict_types=1);
require __DIR__ . '/_helper.php';

if (installer_locked()) {
    http_response_code(403);
    die("Installer is locked. To re-run, delete install/installer.lock (not recommended on production).");
}

if (session_status() !== PHP_SESSION_ACTIVE) session_start();
$csrf = csrf_token();
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <title>Installer - Step 1</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
</head>
<body style="font-family: Arial, sans-serif; max-width: 760px; margin: 32px auto; line-height: 1.4;">
  <h2>App Installer — Step 1</h2>
  <p>Enter database details and your license validation endpoint.</p>

  <form method="post" action="step2_db.php" style="display:grid; gap:10px;">
    <input type="hidden" name="csrf" value="<?=h($csrf)?>">

    <label>DB Host</label>
    <input name="db_host" value="localhost" required style="padding:10px;">

    <label>DB Name</label>
    <input name="db_name" required style="padding:10px;">

    <label>DB User</label>
    <input name="db_user" required style="padding:10px;">

    <label>DB Password</label>
    <input name="db_pass" type="password" style="padding:10px;">

    <label>License Validate URL</label>
    <input name="license_url" placeholder="https://your-license-server.com/validate.php" required style="padding:10px;">

    <button type="submit" style="padding:10px 14px;">Continue</button>
  </form>

  <hr style="margin:20px 0;">
  <small style="color:#666;">
    Security tip: Run installer once, then delete the <code>/install</code> folder.
  </small>
</body>
</html>
